/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.fmteditor.CmdTerminalFrame;
import com.quantumdata.fmteditor.FtpBrowserFrame;
import com.quantumdata.fmteditor.Instrument;
import com.quantumdata.fmteditor.InstrumentSource;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.MsgLogFrame;
import com.quantumdata.fmteditor.MsgLogListener;
import com.quantumdata.fmteditor.StatusPanel;
import com.quantumdata.fmteditor.WindowMenu;
import com.quantumdata.fmteditor.editor.FmtEditorFrame;
import com.quantumdata.fmteditor.file.FileSelectDlg;
import com.quantumdata.fmteditor.file.FmtDataLoader;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.fmteditor.file.FmtReportLoader;
import com.quantumdata.fmteditor.file.LoaderSaver;
import com.quantumdata.fmteditor.file.SourceMenuLoader;
import com.quantumdata.fmteditor.fmt.Format;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.fmteditor.report.FmtReportFrame;
import com.quantumdata.fmteditor.srcmenu.SourceMenuFrame;
import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDCheckBoxMenuItem;
import com.quantumdata.widgets.QDMenu;
import com.quantumdata.widgets.QDMenuBar;
import com.quantumdata.widgets.QDMenuItem;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import com.quantumdata.widgets.QDToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class FmtEditorMain
extends QDPanel
implements MsgLogListener,
IQDConsole,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String VERSION_ID = "1.0.2";
    private JDesktopPane m_desktop;
    private MsgLogFrame m_errorLog;
    private QDCheckBoxMenuItem m_errorLogMenuItem;
    private WindowMenu m_winMenu;
    private StatusPanel m_statusPanel;
    private LoaderSaver m_loader;
    private IQDPluginContext m_ctx;
    private Action m_openAction;
    private Action m_connectAction;
    private Action m_newFormatAction;
    private Action m_newReportAction;
    private Action m_newSourceMenuAction;
    private Action m_saveAction;
    private static FmtEditorMain g_instance;
    private static int m_posX;
    private static int m_posY;

    public static FmtEditorMain instance() {
        return g_instance;
    }

    public FmtEditorMain() {
        g_instance = this;
        QDUtil.setRootResourceClass(FmtEditorMain.class, (String)"com/quantumdata/fmteditor/images/");
        QDStdUI.g_useLargeMenus = false;
        this.setName("Main");
        Instrument.setDefaultComponent((JComponent)((Object)this));
        this.m_openAction = new OpenAction();
        this.m_connectAction = new ConnectAction();
        this.m_newFormatAction = new NewFormatAction();
        this.m_newReportAction = new NewReportAction();
        this.m_newSourceMenuAction = new NewSourceMenuAction();
        this.m_saveAction = new SaveAction();
        this.setLayout(new BorderLayout());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(dimension.width - 180, dimension.height - 180));
        this.m_desktop = new JDesktopPane();
        this.m_desktop.setBackground(Color.black);
        this.add(this.m_desktop, "Center");
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        qDPanel.add((Component)this.createMainMenu(), (Object)"North");
        qDPanel.add((Component)this.createToolBar(), (Object)"South");
        this.add((Component)qDPanel, "North");
        this.m_statusPanel = StatusPanel.instance();
        this.add((Component)((Object)this.m_statusPanel), "South");
        this.m_errorLog = new MsgLogFrame(this);
        MsgLog.addListener(this);
        Instrument.setDefaultConsole(this);
    }

    public void start() {
        JFrame jFrame = (JFrame)this.getTopLevelAncestor();
        jFrame.setTitle("Format Editor: Version 1.0.2");
        this.frameSelectionChanged();
        Instrument.initAppletInstrument();
    }

    public void setContext(IQDPluginContext iQDPluginContext) {
        this.m_ctx = iQDPluginContext;
        Instrument.setContext(iQDPluginContext);
    }

    public boolean close() {
        int n;
        boolean bl = false;
        JInternalFrame[] jInternalFrameArray = this.m_desktop.getAllFrames();
        for (JInternalFrame jInternalFrame : jInternalFrameArray) {
            FmtFrameBase object = (FmtFrameBase)((Object)jInternalFrame);
            if (!object.isModified()) continue;
            bl = true;
            break;
        }
        if (bl && (n = JOptionPane.showConfirmDialog((Component)((Object)this), "You have unsaved, modified data. Are you sure you want to exit?", "Exit without saving?...", 0)) == 1) {
            if (this.m_ctx.isApplet()) {
                for (JInternalFrame jInternalFrame : jInternalFrameArray) {
                    FmtFrameBase fmtFrameBase = (FmtFrameBase)((Object)jInternalFrame);
                    fmtFrameBase.markUnmodified();
                }
            }
            return false;
        }
        if (this.m_ctx.isApplet()) {
            JFrame jFrame = (JFrame)this.getTopLevelAncestor();
            jFrame.dispose();
        } else {
            System.exit(0);
        }
        return true;
    }

    private JMenuBar createMainMenu() {
        QDMenuBar qDMenuBar = new QDMenuBar();
        QDMenu qDMenu = new QDMenu("File");
        qDMenu.setMnemonic(70);
        qDMenuBar.add((JMenu)qDMenu);
        QDMenuItem qDMenuItem = new QDMenuItem(this.m_newFormatAction);
        qDMenuItem.setMnemonic(78);
        qDMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        qDMenu.add((JMenuItem)qDMenuItem);
        qDMenu.add((JMenuItem)new QDMenuItem(this.m_newReportAction));
        qDMenu.add((JMenuItem)new QDMenuItem(this.m_newSourceMenuAction));
        qDMenu.addSeparator();
        qDMenuItem = new QDMenuItem(this.m_openAction);
        qDMenuItem.setMnemonic(79);
        qDMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        qDMenu.add((JMenuItem)qDMenuItem);
        qDMenuItem = new QDMenuItem(this.m_saveAction);
        qDMenuItem.setMnemonic(83);
        qDMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        qDMenu.add((JMenuItem)qDMenuItem);
        qDMenu.addSeparator();
        qDMenuItem = new QDMenuItem("Quit");
        qDMenuItem.setMnemonic(81);
        qDMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        qDMenuItem.setActionCommand("QUIT");
        qDMenuItem.addActionListener((ActionListener)this);
        qDMenu.add((JMenuItem)qDMenuItem);
        qDMenu = new QDMenu("Instrument");
        qDMenu.setMnemonic(73);
        qDMenuItem = new QDMenuItem(this.m_connectAction);
        qDMenu.add((JMenuItem)qDMenuItem);
        qDMenuItem = new QDMenuItem("FTP Browser");
        qDMenuItem.setActionCommand("FTP");
        qDMenuItem.addActionListener((ActionListener)this);
        qDMenuItem.setToolTipText("Open an FTP Browser Window");
        qDMenu.add((JMenuItem)qDMenuItem);
        qDMenuItem = new QDMenuItem("CMD Terminal");
        qDMenuItem.setActionCommand("CMD");
        qDMenuItem.addActionListener((ActionListener)this);
        qDMenuItem.setToolTipText("Open an Instrument CMD Line Terminal");
        qDMenu.add((JMenuItem)qDMenuItem);
        qDMenu.addSeparator();
        qDMenuBar.add((JMenu)qDMenu);
        this.m_winMenu = new WindowMenu("Window");
        this.m_errorLogMenuItem = new QDCheckBoxMenuItem("Message Log...");
        this.m_errorLogMenuItem.setActionCommand("ErrorLog");
        this.m_errorLogMenuItem.addActionListener((ActionListener)this);
        this.m_winMenu.add((JMenuItem)this.m_errorLogMenuItem);
        this.m_winMenu.addSeparator();
        qDMenuBar.add((JMenu)((Object)this.m_winMenu));
        return qDMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand().toLowerCase();
        if (string.equals("ftp")) {
            this.runFtpBrowser();
        } else if (string.equals("cmd")) {
            this.runCmdTerminal();
        } else if (string.equals("errorlog")) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            if (jCheckBoxMenuItem.isSelected()) {
                this.addFrame(this.m_errorLog);
            } else {
                this.m_errorLog.setVisible(false);
            }
        } else if (string.equals("quit")) {
            this.close();
        } else if (string.equals("test")) {
            Instrument.dump();
        }
    }

    private JToolBar createToolBar() {
        QDToolBar qDToolBar = new QDToolBar();
        qDToolBar.add((Component)new QDButton(this.m_connectAction));
        qDToolBar.addSeparator();
        qDToolBar.add((Component)new QDButton(this.m_newFormatAction));
        qDToolBar.add((Component)new QDButton(this.m_newReportAction));
        qDToolBar.add((Component)new QDButton(this.m_newSourceMenuAction));
        qDToolBar.addSeparator();
        qDToolBar.add((Component)new QDButton(this.m_openAction));
        qDToolBar.add((Component)new QDButton(this.m_saveAction));
        return qDToolBar;
    }

    public void addFrame(FmtFrameBase fmtFrameBase) {
        boolean bl = false;
        for (JInternalFrame jInternalFrame : this.m_desktop.getAllFrames()) {
            if (jInternalFrame != fmtFrameBase) continue;
            bl = true;
            break;
        }
        fmtFrameBase.setVisible(true);
        if (!bl) {
            fmtFrameBase.setDefaultCloseOperation(0);
            fmtFrameBase.addInternalFrameListener(new FrameListener());
            fmtFrameBase.setFrameTitle();
            fmtFrameBase.pack();
            this.m_desktop.add((Component)((Object)fmtFrameBase));
            if (!(fmtFrameBase instanceof MsgLogFrame)) {
                this.m_winMenu.addFrame(fmtFrameBase);
            }
            this.positionFrame(fmtFrameBase);
        }
        try {
            fmtFrameBase.setSelected(true);
            if (fmtFrameBase.isIcon()) {
                fmtFrameBase.setMaximum(true);
                fmtFrameBase.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            MsgLog.error("Internal Error: Unable to add frame: " + propertyVetoException.getMessage());
        }
    }

    private void positionFrame(FmtFrameBase fmtFrameBase) {
        Rectangle rectangle = fmtFrameBase.getParent().getBounds();
        Rectangle rectangle2 = fmtFrameBase.getBounds();
        int n = m_posX;
        int n2 = m_posY;
        if (n + rectangle2.width > rectangle.width) {
            n = 0;
        }
        if (n2 + rectangle2.height > rectangle.height) {
            n2 = 0;
        }
        fmtFrameBase.setBounds(n, n2, rectangle2.width, rectangle2.height);
        m_posX = n + 20;
        if (m_posX > 300) {
            m_posX = 20;
        }
        if ((m_posY = n2 + 20) > 300) {
            m_posY = 20;
        }
    }

    public void errorCleared() {
        this.m_statusPanel.setErrorIndictor(false);
        this.m_statusPanel.setMessage("");
    }

    public void errorReported(String string) {
        this.m_errorLog.addError(string);
        this.m_statusPanel.setErrorIndictor(true);
        this.m_statusPanel.setMessage(string);
    }

    public void warningReported(String string) {
        this.m_errorLog.addWarning(string);
        this.m_statusPanel.setWarningIndictor(true);
        this.m_statusPanel.setMessage(string);
    }

    public void msgReported(String string) {
        this.m_errorLog.addMsg(string);
    }

    public void println(String string) {
        this.m_errorLog.addError(string);
    }

    public void clearStatus() {
        this.m_statusPanel.setErrorIndictor(false);
    }

    private void desktopChanged(FmtFrameBase fmtFrameBase, boolean bl) {
        if (fmtFrameBase instanceof MsgLogFrame) {
            this.m_errorLogMenuItem.setSelected(bl);
            return;
        }
        if (bl) {
            this.m_winMenu.addFrame(fmtFrameBase);
        } else {
            this.m_winMenu.removeFrame(fmtFrameBase);
        }
    }

    private void frameSelectionChanged() {
        FmtFrameBase fmtFrameBase = (FmtFrameBase)((Object)this.m_desktop.getSelectedFrame());
        if (fmtFrameBase == null || !fmtFrameBase.isSaveable()) {
            this.m_saveAction.setEnabled(false);
            return;
        }
        this.m_saveAction.setEnabled(true);
    }

    private void closeFrame(FmtFrameBase fmtFrameBase) {
        if (fmtFrameBase.isModified()) {
            if (fmtFrameBase.isSaveable()) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this), "The data has been modifed?\nSave before closing?", "Save before closing?...", 1);
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    this.save(fmtFrameBase, true);
                    return;
                }
            } else {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this), "The data has been modifed?\nAre you sure you want to close?", "Modified data...", 2);
                if (n == 2) {
                    return;
                }
            }
        }
        fmtFrameBase.frameClosing();
        fmtFrameBase.dispose();
    }

    public void openFormat(String string, InstrumentSource instrumentSource) {
        if (this.m_loader != null && this.m_loader.isActive()) {
            return;
        }
        this.clearStatus();
        this.m_statusPanel.showProgress("Loading, please wait...");
        this.m_loader = new FmtDataLoader(string, instrumentSource);
        this.m_loader.start();
    }

    public void useFormat(Format format, InstrumentSource instrumentSource) {
        if (this.m_loader != null && this.m_loader.isActive()) {
            return;
        }
        this.clearStatus();
        this.m_statusPanel.showProgress("Transfering and Using, please wait...");
        this.m_loader = new FmtDataLoader(format, instrumentSource);
        this.m_loader.start();
    }

    private void save(FmtFrameBase fmtFrameBase, boolean bl) {
        if (this.m_loader != null && this.m_loader.isActive()) {
            return;
        }
        if (fmtFrameBase == null) {
            return;
        }
        this.clearStatus();
        FileSelectDlg fileSelectDlg = this.startSave(fmtFrameBase);
        if (fileSelectDlg == null) {
            return;
        }
        if (fmtFrameBase instanceof FmtEditorFrame) {
            this.m_loader = new FmtDataLoader();
        } else if (fmtFrameBase instanceof FmtReportFrame) {
            this.m_loader = new FmtReportLoader();
        } else if (fmtFrameBase instanceof SourceMenuFrame) {
            this.m_loader = new SourceMenuLoader();
        } else {
            MsgLog.error("Unknown data type");
        }
        this.m_loader.save(fileSelectDlg, fmtFrameBase, bl);
        this.m_statusPanel.showProgress("Saving, please wait...");
        this.m_loader.start();
    }

    public FileSelectDlg startSave(FmtFrameBase fmtFrameBase) {
        String string;
        int n;
        MsgLog.msg("Save...");
        JFrame jFrame = (JFrame)this.getTopLevelAncestor();
        FileSelectDlg fileSelectDlg = new FileSelectDlg(jFrame, false, !fmtFrameBase.supportsRemoteFiles(), fmtFrameBase.getFileType(), fmtFrameBase);
        fileSelectDlg.setLocalFileName(fmtFrameBase.getDataName());
        fileSelectDlg.setRemoteFileName(fmtFrameBase.getRemoteDataName());
        fileSelectDlg.setVisible(true);
        if (fileSelectDlg.wasCanceled()) {
            MsgLog.msg("Save canceled");
            return null;
        }
        if (fileSelectDlg.fileExists() && (n = JOptionPane.showConfirmDialog((Component)((Object)this), string = "Overwrite the file: " + fileSelectDlg.getFileName(), "Save File?", 2)) == 2) {
            MsgLog.msg("Save canceled");
            return null;
        }
        return fileSelectDlg;
    }

    public JDesktopPane getDesktop() {
        return this.m_desktop;
    }

    public WindowMenu getWindowMenu() {
        return this.m_winMenu;
    }

    public StatusPanel getStatusPanel() {
        return this.m_statusPanel;
    }

    private void runFtpBrowser() {
        this.clearStatus();
        FtpBrowserFrame ftpBrowserFrame = new FtpBrowserFrame(this.m_ctx);
        this.addFrame(ftpBrowserFrame);
        ftpBrowserFrame.start();
    }

    private void runCmdTerminal() {
        this.clearStatus();
        CmdTerminalFrame cmdTerminalFrame = new CmdTerminalFrame(this.m_ctx);
        this.addFrame(cmdTerminalFrame);
    }

    static {
        m_posX = 20;
        m_posY = 20;
    }

    private class FrameListener
    implements InternalFrameListener {
        private FrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            FmtEditorMain.this.frameSelectionChanged();
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            FmtFrameBase fmtFrameBase = (FmtFrameBase)((Object)internalFrameEvent.getInternalFrame());
            FmtEditorMain.this.desktopChanged(fmtFrameBase, false);
            FmtEditorMain.this.frameSelectionChanged();
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            FmtFrameBase fmtFrameBase = (FmtFrameBase)((Object)internalFrameEvent.getInternalFrame());
            FmtEditorMain.this.closeFrame(fmtFrameBase);
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            FmtEditorMain.this.frameSelectionChanged();
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            FmtEditorMain.this.frameSelectionChanged();
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            FmtEditorMain.this.frameSelectionChanged();
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            FmtFrameBase fmtFrameBase = (FmtFrameBase)((Object)internalFrameEvent.getInternalFrame());
            FmtEditorMain.this.desktopChanged(fmtFrameBase, true);
            FmtEditorMain.this.frameSelectionChanged();
        }
    }

    private class ConnectAction
    extends AbstractAction {
        public ConnectAction() {
            super("Connect");
            this.putValue("SmallIcon", QDUtil.loadIcon((String)"connect.png"));
            this.putValue("ShortDescription", "Establish the default Instrument Connection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MsgLog.msg("Connect...");
            FmtEditorMain.this.clearStatus();
            Instrument.connect((JComponent)((Object)FmtEditorMain.this));
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save");
            this.putValue("SmallIcon", QDUtil.loadIcon((String)"save.png"));
            this.putValue("ShortDescription", "Save the selected Data");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FmtFrameBase fmtFrameBase = (FmtFrameBase)((Object)FmtEditorMain.this.m_desktop.getSelectedFrame());
            FmtEditorMain.this.save(fmtFrameBase, false);
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super("Open");
            this.putValue("SmallIcon", QDUtil.loadIcon((String)"open.png"));
            this.putValue("ShortDescription", "Open a file");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FmtEditorMain.this.m_loader != null && FmtEditorMain.this.m_loader.isActive()) {
                return;
            }
            FmtEditorMain.this.clearStatus();
            MsgLog.msg("Open...");
            JFrame jFrame = (JFrame)FmtEditorMain.this.getTopLevelAncestor();
            FileSelectDlg fileSelectDlg = new FileSelectDlg(jFrame, true, false, FmtFileType.FORMAT, new DefaultSource());
            fileSelectDlg.setVisible(true);
            if (fileSelectDlg.wasCanceled()) {
                return;
            }
            FmtEditorMain.this.m_statusPanel.showProgress("Loading, please wait...");
            switch (fileSelectDlg.getFileType()) {
                case FORMAT: {
                    FmtEditorMain.this.m_loader = new FmtDataLoader();
                    break;
                }
                case REPORT: {
                    FmtEditorMain.this.m_loader = new FmtReportLoader();
                    break;
                }
                case MENU: {
                    FmtEditorMain.this.m_loader = new SourceMenuLoader();
                    break;
                }
                default: {
                    FmtEditorMain.this.m_statusPanel.hideProgress();
                    MsgLog.error("Invalid file type");
                    return;
                }
            }
            FmtEditorMain.this.m_loader.open(fileSelectDlg, new DefaultSource());
            FmtEditorMain.this.m_loader.start();
        }
    }

    private class DefaultSource
    implements InstrumentSource {
        private DefaultSource() {
        }

        public RemoteInstrument getInstrument() {
            return Instrument.getDefault();
        }

        public JComponent getInstrumentOwner() {
            return FmtEditorMain.this;
        }

        public boolean isConnected() {
            return this.getInstrument() != null && this.getInstrument().isConnected();
        }

        public void setInstrument(RemoteInstrument remoteInstrument) {
        }
    }

    private class NewSourceMenuAction
    extends AbstractAction {
        public NewSourceMenuAction() {
            super("New Source Menu");
            this.putValue("SmallIcon", QDUtil.loadIcon((String)"new.png"));
            this.putValue("ShortDescription", "Create a new Source Menu");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FmtEditorMain.this.clearStatus();
            SourceMenuFrame sourceMenuFrame = new SourceMenuFrame();
            FmtEditorMain.this.addFrame(sourceMenuFrame);
            MsgLog.msg("New Source Menu created: " + sourceMenuFrame.getDataName());
        }
    }

    private class NewReportAction
    extends AbstractAction {
        public NewReportAction() {
            super("New Report");
            this.putValue("SmallIcon", QDUtil.loadIcon((String)"new.png"));
            this.putValue("ShortDescription", "Create a new Format Summary Report");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FmtEditorMain.this.clearStatus();
            FmtReportFrame fmtReportFrame = new FmtReportFrame();
            FmtEditorMain.this.addFrame(fmtReportFrame);
            MsgLog.msg("New Format Summary Report created: " + fmtReportFrame.getDataName());
        }
    }

    private class NewFormatAction
    extends AbstractAction {
        private int m_nextId;

        public NewFormatAction() {
            super("New Format");
            this.m_nextId = 1;
            this.putValue("SmallIcon", QDUtil.loadIcon((String)"new.png"));
            this.putValue("ShortDescription", "Create a new Format");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FmtEditorMain.this.clearStatus();
            Format format = new Format();
            String string = "newfmt" + this.m_nextId;
            MsgLog.msg("New Format created: " + string);
            ++this.m_nextId;
            format.setName(string, true);
            FmtEditorFrame fmtEditorFrame = new FmtEditorFrame(format);
            FmtEditorMain.this.addFrame(fmtEditorFrame);
        }
    }
}

